IF OBJECT_ID('UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL') IS NOT NULL
	BEGIN
		DROP FUNCTION UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL
	END
  
GO
  
--Select * From UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL(1,15,'20101101','20101130') Order By CD_CTB_CNT  
CREATE FUNCTION [dbo].[UFD_PDV_VD_IT_RATEIO_POR_SECAO_CUSTO_CONTABIL] (  
        @CD_EMP  INT,  
        @CD_FILIAL INT,  
        @DT_INI      DATETIME,  
        @DT_FIM      DATETIME)  
RETURNS @RS_PROD_VD TABLE (
	   CD_EMP			INT,  
	   CD_FILIAL		INT,
	   DT_VD			DATETIME,
       CD_SC			INT,  
       DS_SC			VARCHAR(150),  
       CD_CTB_CNT_RED   INT,  
       CD_CTB_CNT		VARCHAR(100),         
       VLR_CUSTO         MONEY)  
AS  
BEGIN  
  
INSERT INTO @RS_PROD_VD  
 SELECT  
  PDV_VD.CD_EMP,
  PDV_VD.CD_FILIAL,
  PDV_VD.DT_VD,
  0,    
  '',  
  0,  
  '',   
  ISNULL(SUM(PDV_VD_IT.VLR_CUSTO_MEDIO *  PDV_VD_IT.QT_IT),0)  
 FROM           
  PDV_VD INNER JOIN PDV_VD_IT ON  
  PDV_VD.CD_EMP = PDV_VD_IT.CD_EMP AND  
  PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND  
  PDV_VD.CD_VD = PDV_VD_IT.CD_VD   
 WHERE  
  PDV_VD.CD_EMP = @CD_EMP  
  AND PDV_VD.CD_FILIAL = @CD_FILIAL  
  AND PDV_VD.DT_VD BETWEEN @DT_INI AND @DT_FIM  
  AND PDV_VD.ST_VD = 0  
  AND PDV_VD_IT.ST_IT = 1  
 GROUP BY
	PDV_VD.CD_EMP,
	PDV_VD.CD_FILIAL,
    PDV_VD.DT_VD
RETURN  
END  
  